#ifndef INTERRUPT_FORM_H
#define INTERRUPT_FORM_H

#include <QWidget>
#include <QCloseEvent>
#include <QCheckBox>

#include "public_parameter.h"

namespace Ui {
    class Interrupt_Form;
}

class Interrupt_Form : public QWidget
{
    Q_OBJECT

public:
    explicit Interrupt_Form(QWidget *parent = 0, Qt::WindowFlags fl = 0 );
    ~Interrupt_Form();
    // sub fuction:
    void mask_read();
    void status_read();

public:
      int interrupt_timer;
      bool timer_started;


protected:
      void timerEvent ( QTimerEvent *event);
      void closeEvent ( QCloseEvent *event );
      void showEvent ( QShowEvent * );

private slots:
      void on_IrqEnable_checkBox_clicked(bool checked);

      void on_Apply_pushButton_clicked();

      void on_TtlIrqPolarity_checkBox_clicked(bool checked);

private:
    Ui::Interrupt_Form *ui;
    // Object array
    QCheckBox *Bit_checkBox[10];
    QCheckBox *State_checkBox[10];
};

#endif // INTERRUPT_FORM_H
